// MarkaJiap Markdown Renderer
// Runs after marked.js is loaded to render markdown properly

(function() {
  'use strict';
  
  console.log('📝 MarkaJiap Renderer: Starting...');
  
  if (typeof marked === 'undefined') {
    console.error('❌ MarkaJiap Renderer: marked not found');
    return;
  }
  
  console.log('📝 MarkaJiap Renderer: marked found');
  
  // Get the raw markdown from a data attribute
  const contentEl = document.getElementById('markajiap-content');
  if (!contentEl) {
    console.error('❌ MarkaJiap Renderer: content element not found');
    return;
  }
  
  const rawMarkdown = contentEl.getAttribute('data-raw-markdown');
  if (!rawMarkdown) {
    console.error('❌ MarkaJiap Renderer: no raw markdown found');
    return;
  }
  
  console.log('📝 MarkaJiap Renderer: markdown length:', rawMarkdown.length);
  
  // Configure marked
  marked.setOptions({
    gfm: true,
    breaks: true,
    headerIds: true,
    mangle: false
  });
  
  // Parse markdown
  let html = marked.parse(rawMarkdown);
  
  // Convert mermaid code blocks to divs
  html = html.replace(/<pre><code class="language-mermaid">([\s\S]*?)<\/code><\/pre>/gi, function(m, code) {
    // Unescape HTML entities
    var unescaped = code
      .replace(/&lt;/g, '<')
      .replace(/&gt;/g, '>')
      .replace(/&amp;/g, '&')
      .replace(/&quot;/g, '"')
      .replace(/&#39;/g, "'");
    return '<div class="mermaid">' + unescaped + '</div>';
  });
  
  // Check mermaid count
  var mermaidCount = (html.match(/class="mermaid"/g) || []).length;
  console.log('📝 MarkaJiap Renderer: Found', mermaidCount, 'mermaid blocks');
  
  // Update content
  contentEl.innerHTML = html;
  contentEl.removeAttribute('data-raw-markdown');
  
  // Dispatch event to signal completion
  window.dispatchEvent(new CustomEvent('markajiap-render-complete'));
  
  console.log('📝 MarkaJiap Renderer: Complete!');
})();
