// MarkaJiap Syntax Highlighter
// Runs after highlight.js is loaded to colorize code blocks

(function() {
  'use strict';
  
  console.log('🎨 MarkaJiap Highlighter: Starting...');
  
  if (typeof hljs === 'undefined') {
    console.error('❌ MarkaJiap Highlighter: hljs not found');
    return;
  }
  
  console.log('🎨 MarkaJiap Highlighter: hljs found, version:', hljs.versionString || 'unknown');
  
  // Configure highlight.js to ignore unescaped HTML warnings
  hljs.configure({
    ignoreUnescapedHTML: true
  });
  
  // Find all code blocks in the MarkaJiap content
  const codeBlocks = document.querySelectorAll('#markajiap-content pre code');
  console.log('🎨 MarkaJiap Highlighter: Found', codeBlocks.length, 'code blocks');
  
  codeBlocks.forEach(function(block, index) {
    // Get language from multiple sources:
    // 1. Parent pre data-lang attribute (custom parser)
    // 2. Code element class="language-xxx" (marked.js)
    // 3. Code element class="xxx" (other parsers)
    const pre = block.closest('pre');
    let lang = '';
    
    // Check data-lang first
    if (pre && pre.getAttribute('data-lang')) {
      lang = pre.getAttribute('data-lang');
    }
    // Check code element class for language-xxx pattern
    else if (block.className) {
      const classMatch = block.className.match(/language-(\w+)/);
      if (classMatch) {
        lang = classMatch[1];
      } else {
        // Try to extract from any class that looks like a language
        const classes = block.className.split(' ');
        for (var i = 0; i < classes.length; i++) {
          if (classes[i] && hljs.getLanguage(classes[i])) {
            lang = classes[i];
            break;
          }
        }
      }
    }
    
    // Skip mermaid blocks
    if (lang === 'mermaid') {
      console.log('🎨 MarkaJiap Highlighter: Skipping mermaid block', index + 1);
      return;
    }
    
    // Ensure hljs class is present
    if (!block.classList.contains('hljs')) {
      block.classList.add('hljs');
    }
    if (lang && !block.classList.contains('language-' + lang)) {
      block.classList.add('language-' + lang);
    }
    
    try {
      hljs.highlightElement(block);
      console.log('🎨 MarkaJiap Highlighter: Highlighted block', index + 1, 'as', lang || 'auto');
    } catch (e) {
      console.log('🎨 MarkaJiap Highlighter: Could not highlight block', index + 1, ':', e.message);
    }
  });
  
  console.log('🎨 MarkaJiap Highlighter: Complete!');
})();

