# MarkaJiap

<p align="center">
  <img src="icons/icon128.svg" width="128" height="128" alt="MarkaJiap Logo">
</p>

**Beautiful Markdown Viewer for Chrome** – Render, preview, and export Markdown files with lucky colors for wealth & prosperity.

🔮 **สีมงคลเสริมการเงิน** สำหรับคนเกิดวันอาทิตย์ (11 ส.ค. 2528)

Created by **Jiap**

---

## 🎨 Lucky Color Palette

| สี | Hex | ความหมาย |
|---|-----|----------|
| 🟣 ม่วง | `#7B2D8E` | เสริมโชคลาภ การเงิน |
| 🟡 ทอง | `#D4A634` | เสริมบารมี ความมั่งคั่ง |
| ⚫ ดำ | `#1A1625` | ความมั่นคง |

---

## ✨ Features

### Core Rendering
- ✅ **GitHub Flavored Markdown (GFM)** - Full support for GFM syntax
- ✅ **Syntax Highlighting** - 180+ programming languages supported
- ✅ **Mermaid Diagrams** - Flowcharts, sequence diagrams, Gantt charts, and more
- ✅ **LaTeX Math** - Mathematical equations with KaTeX
- ✅ **Task Lists** - Interactive checkbox lists
- ✅ **Tables** - Full table support with styling
- ✅ **Auto-detection** - Automatically renders `.md` files

### Multiple Input Methods
- 📋 **Paste** - Paste Markdown text directly
- 📁 **File Upload** - Drag & drop or browse for files
- 🌐 **URL Fetch** - Load from GitHub, GitLab, or any URL

### Export Options
- 📄 **Export to HTML** - Save as standalone HTML file
- 🖨️ **Export to PDF** - Print to PDF with styling preserved
- 📋 **Copy HTML** - Copy rendered HTML to clipboard
- 📋 **Copy Markdown** - Copy original Markdown source

### User Experience
- 🌓 **Dark Mode** - Beautiful dark theme with JVC branding
- 📑 **Table of Contents** - Auto-generated navigation sidebar
- 🔍 **Search** - Full-text search within documents
- 📊 **Reading Progress** - Progress bar while scrolling
- ⌨️ **Keyboard Shortcuts** - Quick actions with hotkeys
- 🎨 **Custom CSS** - Add your own styling

---

## 🚀 Installation

### From Source (Developer Mode)

1. Download or clone this repository
2. Open Chrome and navigate to `chrome://extensions/`
3. Enable **Developer mode** (toggle in top-right corner)
4. Click **Load unpacked**
5. Select the `jvc-markview` folder

### File Structure

```
jvc-markview/
├── manifest.json          # Extension configuration
├── popup.html             # Popup UI
├── viewer.html            # Main viewer page
├── options.html           # Settings page
├── css/
│   ├── main.css           # Core styles
│   ├── viewer.css         # Viewer layout styles
│   ├── popup.css          # Popup styles
│   ├── options.css        # Options page styles
│   └── content.css        # Content script styles
├── js/
│   ├── background.js      # Service worker
│   ├── popup.js           # Popup logic
│   ├── viewer.js          # Markdown rendering
│   ├── content.js         # Content script
│   └── options.js         # Settings logic
└── icons/
    ├── icon16.png
    ├── icon32.png
    ├── icon48.png
    └── icon128.png
```

---

## ⌨️ Keyboard Shortcuts

| Shortcut | Action |
|----------|--------|
| `Ctrl + F` | Search in document |
| `Ctrl + P` | Print / Export to PDF |
| `Ctrl + B` | Toggle sidebar |
| `Esc` | Close search / dialogs |
| `↑ / ↓` | Navigate search results |
| `Enter` | Jump to search result |

---

## 🔮 สีมงคลตามหลักโหราศาสตร์

Extension นี้ใช้สีมงคลสำหรับคนเกิดวันอาทิตย์:

- **ม่วง** (`#7B2D8E`) - เสริมโชคลาภ การเงิน
- **ทอง** (`#D4A634`) - เสริมบารมี ความมั่งคั่ง  
- **ดำ** (`#1A1625`) - ความมั่นคง มีผู้อุปถัมภ์

---

## 🔧 Configuration

Open the extension options to customize:

- **Theme** - Light/Dark mode
- **Auto-render** - Automatically render .md files
- **Table of Contents** - Show/hide sidebar
- **Mermaid Diagrams** - Enable diagram rendering
- **Math Equations** - Enable KaTeX rendering
- **Font Size** - Adjust base font size
- **Custom CSS** - Add your own styles

---

## 📝 Supported Markdown Features

### Basic Syntax
- Headings (H1-H6)
- Bold, Italic, Strikethrough
- Links and Images
- Blockquotes
- Ordered and Unordered Lists
- Horizontal Rules

### Extended Syntax
- Fenced Code Blocks
- Tables
- Task Lists
- Footnotes
- Definition Lists
- Abbreviations
- Emoji (`:smile:`)

### Special Features
- Mermaid Diagrams
- LaTeX Math (`$...$` and `$$...$$`)
- GitHub Alerts (`> [!NOTE]`, `> [!WARNING]`, etc.)

---

## 📜 License

© 2024 Jiap. All rights reserved.

🔮 เกิดวันอาทิตย์ 11 ส.ค. 2528 เวลา 00:09 น.

---

## 🙏 Credits

- [marked.js](https://marked.js.org/) - Markdown parser
- [highlight.js](https://highlightjs.org/) - Syntax highlighting
- [Mermaid](https://mermaid.js.org/) - Diagrams
- [KaTeX](https://katex.org/) - Math rendering
- [DOMPurify](https://github.com/cure53/DOMPurify) - HTML sanitization
- [IBM Plex](https://www.ibm.com/plex/) - Typography
